/**
* \file: IControlAdapterParameters.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_ICONTROLADAPTERPARAMETERS_H
#define CARPLAY_ICONTROLADAPTERPARAMETERS_H

#include "IControlAdapter.h"
#include "AirPlayHeaders.h"

namespace adit { namespace carplay
{

Entity AirPlay2Entity(AirPlayEntity value);
SpeechState AirPlay2SpeechState(AirPlaySpeechState value);
ModeState AirPlay2ModeState(const AirPlayModeState& value);

AirPlayEntity Entity2AirPlay(Entity value);
AirPlaySpeechState SpeechState2AirPlay(SpeechState value);
AirPlayTriState AppState2AirPlay(const AppState& value);
AirPlayResourceChange ResourceTransfer2AirPlay(const ResourceTransfer& value);
void ModeChanges2AirPlay(const ModeChanges& from, AirPlayModeChanges& to);

AirPlaySiriAction SiriAction2AirPlay(SiriAction value);

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_ICONTROLADAPTERPARAMETERS_H */
